#include <sys/types.h>

/* headers and other structures for TI variables */

/* it seems that all words are sent in LSB format.  this seems a bit
   odd to be coming from a motorola chip, but ok */

/* variable types for the 92 */

#define VAR92_DATA 0x0a
#define VAR92_EXPR 0x00
#define VAR92_FIG 0x0e
#define VAR92_FUNC 0x13
#define VAR92_GRAPH 0x0d
#define VAR92_LIST 0x04
#define VAR92_MACRO 0x14
#define VAR92_MATRIX 0x06
#define VAR92_PIC 0x10
#define VAR92_PRGM 0x12
#define VAR92_STRING 0x0c
#define VAR92_TEXT 0x0b
#define VAR92_GROUP 0x1f

/* file types, last byte matches for disk name */
static char filetypes_92[] = "e---l-m---ctsda-i-pfx---h----b-g-z---------------r";

typedef struct _TI_File92 {
     unsigned char magic[8];
     unsigned char sep1[2];
     unsigned char folder[8];
     unsigned char ident[40];
     unsigned char sep2[6];
     unsigned char name[8];
     unsigned char sep3[4];
     unsigned char length[4];
     unsigned char sep4[6];
} TI_File92;

/* directory entry */

typedef struct _TI_Dir92 {
     unsigned char nulls[4];
     unsigned char name[8];
     unsigned char type;
     unsigned char status;
     unsigned short size[2];
     unsigned short checksum;
} TI_Dir92;

/* our internal representation of the directory structure */

struct ti_dirent {
     unsigned char path[40];
     unsigned char name[8];
     unsigned char type;
     struct ti_dirent *next;
};

typedef struct _TI_Varhead92 {
     unsigned short length;
     unsigned char junk1;
     unsigned char junk2;
     unsigned char type;
     unsigned char namelen;
} TI_Varhead92;

    
/* 6 bytes come before the variable data */

typedef struct _TI_Varjunk92 {
     unsigned char junk[4];
     unsigned char size[2];
} TI_Varjunk92;

#define do_size(x) (x[1] << 8 | x[0])
#define rev_size(x) (x[0] << 8 | x[1])

/* functions in vars.c */
int save_var(char *name, int type, void *data, unsigned short len);
void *load_var(char *filename, int *len, char *varname, char *folder);

