
#include <stdio.h>
#include <unistd.h>
#include <curses.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include "vars.h"
#include "prot.h"
#include "display.h"

extern int calc_model;

/* I think we leak ram here */
int save_var(char *name, int type, void *data, unsigned short len) {

     int fd;
     TI_File92 head;
     char filename[20];
     char *varname;
     char *folder;
     unsigned short chksum;
     unsigned char mark;
     unsigned int headlen;
     unsigned char nlen[2];
     void *tmpbuf;
     
     varname = strdup(name);
     folder = strsep(&varname, "\\");

     sprintf(filename, "%s.%d%c", varname, calc_model,
	     filetypes_92[type]);

     if((fd = open(filename, O_WRONLY | O_CREAT, S_IRUSR)) == -1) {
	  pmain("Unable to open %d for write\n", name);
	  return -1;
     }

     memset(&head, 0, sizeof(TI_File92));

     if(calc_model == 89)
	  strncpy(head.magic, "**TI89**",8);
     else
	  strncpy(head.magic, "**TI92**",8);
     
     head.sep1[1] = 1;
     strncpy(head.folder, folder, 8);
          
     head.sep2[0] = 0x01;
     head.sep2[2] = 0x52;

     strncpy(head.name, varname, 8);
     
     head.sep3[0] = type;    
    
     /* guessing... */
     headlen = (unsigned int)(sizeof(TI_File92) + 2 + len + 2); 
     
     memcpy(head.length, &headlen, 4);
	  
     head.sep4[0] = 0xa5;
     head.sep4[1] = 0x5a;

     nlen[1] = (unsigned char)(len & 0x00ff);
     nlen[0] = (unsigned char)(len >> 8); 

     /* alright, hopefully that was enough magic to mimic a TI header
      */
     
     write(fd, &head, sizeof(TI_File92));
     write(fd, nlen, 1);
     write(fd, &nlen[1], 1);
     
     /* texts get mangled, we have to fix 2 bytes.. */
     if(type == VAR92_TEXT) {
	  ((unsigned char *)data)[0] = 0;
	  ((unsigned char *)data)[1] = 1;
     }

     write(fd, data, len);
/*
     tmpbuf = alloca(len+2+sizeof(TI_File92));
     memcpy(tmpbuf, &head, sizeof(TI_File92));
     memcpy(tmpbuf+sizeof(TI_File92), &nlen[0], 1);
     memcpy(tmpbuf+sizeof(TI_File92)+1, &nlen[1], 1);
     memcpy(tmpbuf+sizeof(TI_File92)+2, data, len);
*/
     tmpbuf = alloca(len+2);
     memcpy(tmpbuf,&nlen[0], 1);
     memcpy(tmpbuf+1, &nlen[1], 1);
     memcpy(tmpbuf+2, data, len);

     chksum = calc_sum(tmpbuf, len+2);
     write(fd, &chksum, 2);
     
     close(fd);
     
     return 0;
}

/* loads a ti-format variable from disk.  hopefully does it right */

void *load_var(char *filename, int *len, char *varname, char *folder) {

     TI_File92 head;
     int fd;
     int type;
     unsigned short size;
     unsigned char rsize[2];
     void *ret;

     if((fd = open(filename, O_RDONLY)) == -1) {
	  pmain("Unable to open %s\n", filename);
	  return NULL;
     }

     type = filename[strlen(filename)-1];
     
     /* first is some header data */
     read(fd, &head, sizeof(TI_File92));
     /* now the actual size of the variable, byte reversed */
     read(fd, rsize, 2);
     size = rev_size(rsize);

     /* extract foldername and varname */
     strncpy(folder, head.folder, 8);
     strncpy(varname, head.name, 8);
     
     pmain("Reading %d bytes from %s\n", size, filename);
     ret = malloc(size);
     read(fd, ret, size);
     
     /* all file types have superfluous data now, but, we really
	couldn't care less about it */
     close(fd);
     
     (*len) = size;
     return ret;

}
