#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

main() {

     int pcfd, tifd;
     struct termios termset;
     int len, i;
     unsigned char buf[8192];

     if((tifd = open("/dev/ti", O_RDWR)) == -1) {
	  perror("tiopen");
	  exit(1);
     }

     if((pcfd = open("/dev/ttyS0", O_RDWR)) == -1) {
	  perror("pcopen");
	  exit(1);
     }

     tcgetattr(pcfd, &termset);
     cfmakeraw(&termset);
     cfsetospeed(&termset, B9600);
     cfsetispeed(&termset, B9600);
     tcsetattr(pcfd, TCSANOW, &termset);
     
     while(1) {
	  
	  len = read(pcfd, buf, 8192);
	  printf("%d bytes from windows\n", len);
	  printf("win: ");
	  i = 0;
	  while(i < len) {
	       printf("%x ", buf[i]);
	       i++;
	  }
	  printf("\n");
	  
	  write(tifd, buf, len);
	  len = read(tifd, buf, 8192);
	  printf("%d bytes from ti\n", len);
	  printf("ti: ");
	  i = 0;
	  while(i < len) {
	       printf("%x ", buf[i]);
	       i++;
	  }
	  printf("\n");
	  
	  write(pcfd, buf, len);
	  
     }
}

		     
