
/* protocol for talking to a ti calculator over the graph link. */

/* byte 0, device type identification */

#define DEV_COMP_82 0x02
#define DEV_COMP_85 0x05
#define DEV_COMP_89 0x08
#define DEV_COMP_92 0x09
#define DEV_82_COMP 0x82
#define DEV_85_COMP 0x85
#define DEV_92_COMP 0x89
#define DEV_89_COMP 0x98

/* byte 1, command byte */

#define COM_VAR 0x06
#define COM_WAIT 0x09
#define COM_DATA 0x15
#define COM_OK 0x56
#define COM_CHKERR 0x5a
#define COM_TEST92 0x68
#define COM_SCRDUMP 0x6d
#define COM_CONTINUE 0x78
#define COM_DIRECT 0x87
#define COM_EOT 0x92
#define COM_REQ 0xa2
#define COM_SEND 0xc9 /* sending a variable */

/* known ti92 request commands (sent as length) */
#define REQ_BACKUP 0x11
#define REQ_VAR 0x10
#define REQ_DIR 0x6
#define REQ_CHFOLD 0x0a

/* known strings of data producing a request action */

/* used with REQ_DIR */
/* directories every variable, starting in the current folder */
static char req_fulldir[] = {0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x19, 0x00};
/* lists folders */
static char req_folders[] = {0x00, 0x00, 0x00, 0x1f, 0x1a, 0x00, 0x39, 0x00};

/* used with REQ_CHFOLD */
static char req_chfold[] = {0x00, 0x00, 0x00, 0x1b, 0x1a};

/* structures for the packets */

typedef struct _TI_Packet {
     unsigned char device;
     unsigned char command;
     unsigned short length;
} TI_Packet;

/* calculates checksum */

static inline unsigned short calc_sum(void *data, int len) {

     unsigned char *bleh = (unsigned char *)data;
     int i;
     int ret = 0;

     for(i = 0; i < len ; i++)
	  ret += bleh[i];

     ret &= 0xFFFF;

     return (unsigned short) ret;

}
