#include <stdio.h>
#include <unistd.h>
#include <curses.h>
#include <sys/time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>

#include "prot.h"
#include "keymaps.h"
#include "display.h"
#include "comm.h"
#include "vars.h"

static void menu_loop(void);
static void command_mode(void);
static void menu_help(void);
static void usage(char *arg);

main(int ac, char **av) {

     if(ac < 3)
	  usage(av[0]);

     init_disp();
     init_keys();
     
     init_comm(atoi(av[1]), av[2]);
     
     menu_loop();
     
     return;

}

/* basic main menu, talks to the ti */

void menu_loop(void) {

     int ch;

     do {
	  pcomm("Command: ");
	  ch = get_key();
	  
	  switch(ch) {
	  case 'c':
	       command_mode();
	       break;
	  case 'l':
	       dir_full();
	       break;
	  case 'f':
	       dir_folders();
	       break;
	  case 'h':
	  case '?':
	       menu_help();
	       break;
	  case 'r': {
	       
	       char var[40];
	       int type = 0xff;
	       int typech, i = 0;

	       pcomm("Variable [folder\\name]: ");
	       get_str(var);

	       pcomm("Variable type: ");
	       typech = get_key();
	       for(i = 0; i < strlen(filetypes_92); i++) 
		    if(filetypes_92[i] == typech) 
			 type = i;
	       if(type == 0xff) {
		    pmain("Invalid type %c\n", typech);
		    break;
	       }

	       get_var(var, type);
	       break;
	  }
	  case 's': {
	       
	       char filename[40];
	       
	       pcomm("Filename: ");
	       get_str(filename);
	       
	       send_var(filename);
	       break;
	  }
	       
	  case 'q':
	       break;
	  default:
	       pmain("Unknown command\n");
	       break;
	  }

     } while(ch != 'q');
     
     
     return;

}

/* just tries to do direct command mode on the 89 */

void command_mode(void) {

     int ch;

     noecho();

     while(1) {
	  ch = get_key();
	  
	  ascii_fix(&ch);
	  if(ch == CMD_MODE_EXIT)
	       break;

	  command_key(ch);
     }

     echo();
	  
}

void menu_help(void) {

     pmain("The following keys are available:\n");
     pmain("\tc\tenter command mode (alt-shift-q to leave)\n");
     pmain("\ts\tsend a variable\n");
     pmain("\tr\trecieve a variable\n");
     pmain("\tl\tfull directory listing\n");
     pmain("\tf\tlist of folders\n");
     pmain("\tq\tquit\n\n");
     
     return;

}

void usage(char *arg) {
     printf("usage:\t%s <model> <device>\n", arg);
     printf("ex:\t%s 89 /dev/ti\n", arg);
     printf("\tfor a ti89 on /dev/ti\n");
     printf("or\n");
     printf("\t%s 92 /dev/ttyS0\n", arg);
     printf("\tfor a ti92 on ttyS0 with a TI cable\n");
     exit(1);
}
