
/* this array holds keymappings for all the key codes from 0x80 to
   0x17f.  keymaps.c contains init_keys() which is where the memory is
   allocated and the maps are made.  more explanation there */

unsigned short *keytrans;

void init_keys(void);

/* Fixes up some keys in the low range which can be problematic */
static inline void ascii_fix(int *key) {

     /* save stuff that could be valid ascii */
     if((keytrans[(*key)] == 0) && ((*key) < 0x80)) 
	  return;

     /* anything this big is out of our grasp, just clear it */
     if((*key) >= 0x200) {
	  (*key) = 0;
	  return;
     }

     (*key) = keytrans[(*key)];
     
     return;

}

/* magic for exiting command mode */
#define CMD_MODE_EXIT 65535
