
/* edit this file to customize your key bindings when remotely
   controlling the calc */

#include <curses.h>
#include <stdlib.h>
#include "keymaps.h"

/* makes matters a bit more conveinent to have this */
/* META(x) represents a keystroke with the alt key pressed. */
#define META(x) (x | 0x80)

/* using capital letters here produces proper results, though
   case-sensitive meta should work fine, since it's gonna get kludged on
   most consoles anyway */
#define CTRL(x) (x ^ 0x40)
#define ktrans(x, y) (keytrans[x] = y)

/* calloc's the array for translation -- anything left as a 0 will not
   be passed, unless there is a 0 value for something < 0x80, in which
   case it is assumed that the ascii value is proper */

void init_keys(void) {

     keytrans = calloc(0x200, sizeof(unsigned short));

     /* this mapping seems to work alright on my 89 */

     /* arrows are knackered.  ncurses seems to behave correctly, I
	blame TI for this... I've fixed it up here */
     ktrans(KEY_DOWN, 340);
     ktrans(KEY_UP, 337);
     ktrans(KEY_LEFT, 338);
     ktrans(KEY_RIGHT, 344);
     ktrans(KEY_BACKSPACE, 257);
     /* fix up the other potential backspace issues */
     ktrans(0x08, 257);
     ktrans(0x7f, 257);
     
     ktrans(KEY_F(1), 268);
     ktrans(KEY_F(2), 269);
     ktrans(KEY_F(3), 270);
     ktrans(KEY_F(4), 271);
     ktrans(KEY_F(5), 272);
     ktrans(KEY_F(6), 273);
     ktrans(KEY_F(7), 274);
     ktrans(KEY_F(8), 275);
     ktrans(KEY_DC, 8449);
     ktrans(KEY_IC, 4353);
     ktrans(KEY_CLEAR, 263);
     ktrans(KEY_NPAGE, 4436);
     ktrans(KEY_PPAGE, 4433);
     ktrans(KEY_HOME, 8529);
     ktrans(KEY_END, 8532);
     ktrans(KEY_ENTER, 13);
     /* ncurses changes cr's to 12, fix this */
     ktrans('\n', '\r');
     
     /* the rest of the ncurses defined keys are pretty damn rare... I
	don't see any reason in finding bindings for them */

     /* here are some keys I'm rather fond of */
     /* emacs-ish keys */
     ktrans(CTRL('A'), 4434); 
     ktrans(CTRL('E'), 4440);
     ktrans(CTRL('K'), 263);

     /* keys from the machine I'd like to have */
     /* esc doesn't work because of various forms of terminal
	emulation, I'm redefining tab to it, simply because I can't
	really find a stellar use for tab on the calculator */
     ktrans('\t', 264);
     ktrans(META('\t'), 4360); /* alt-tab becomes quit... */

     /* everything from here on out is basically a matter of
	preference... */

     /* shift-fkey does the labels over the fkeys (window, y=, etc) */
     ktrans(KEY_F(11), 8460);
     ktrans(KEY_F(12), 8461);
     ktrans(KEY_F(13), 8462);
     ktrans(KEY_F(14), 8463);
     ktrans(KEY_F(15), 8464);

     ktrans(META('1'), 265); /* apps */
     ktrans(META('2'), 4361); /* sh-apps */
     ktrans(META('3'), 277); /* home */ 
     ktrans(META('4'), 4373);
     ktrans(META('5'), 266); /* mode */
     ktrans(META('6'), 18);
     ktrans(META('7'), 278); /* catalog */
     ktrans(META('8'), 151);
     ktrans(META('l'), 4184); /* ln */
     ktrans(META('e'), 8230); /* e^x */
     ktrans(META('s'), 4185); /* sin */
     ktrans(META('S'), 8281); /* sin -1 */
     ktrans(META('c'), 4186); /* cos */
     ktrans(META('C'), 8282); /* cos -1 */
     ktrans(META('t'), 4180); /* tan */
     ktrans(META('T'), 8276);
     ktrans(META('\r'), 8205); /* approx */
     ktrans(META(','), 156); /* lt or equal */
     ktrans(META('.'), 158); /* gt or equal */

     /* ctrl-x shall exit command mode */
     ktrans(META('Q'), CMD_MODE_EXIT);

}

